/*!
Various function presentations, useful as convolution kernels.

The kernels typically implement
 * [`Mapping`][alg_tools::mapping::Mapping] for value evaluation
 * [`Support`][alg_tools::bisection_tree::Support] for insertion into
   [́`BT`][alg_tools::bisection_tree::BT] bisection tree
 * [`GlobalAnalysis`][alg_tools::bisection_tree::GlobalAnalysis] on
   [`Bounds`][alg_tools::bisection_tree::Bounds] for bounding the kernel globally.
 * [`LocalAnalysis`][alg_tools::bisection_tree::LocalAnalysis] on
   [`Bounds`][alg_tools::bisection_tree::Bounds] for
   bounding the kernel locally on a [`Cube`][alg_tools::sets::Cube].
*/

mod base;
pub use base::*;
mod mollifier;
pub use mollifier::*;
mod hat;
pub use hat::*;
mod gaussian;
pub use gaussian::*;
mod ball_indicator;
pub use ball_indicator::*;
mod hat_convolution;
pub use hat_convolution::*;
mod linear;
pub use linear::*;


