/*!
Fourier transform traits
*/

use alg_tools::types::{Num, Float};
use alg_tools::mapping::{RealMapping, Mapping};
use alg_tools::bisection_tree::Weighted;
use alg_tools::loc::Loc;

/// Trait for Fourier transforms. When F is a non-complex number, the transform
/// also has to be non-complex, i.e., the function itself symmetric.
pub trait Fourier<F : Num> : Mapping<Self::Domain, Codomain=F> {
    type Domain;
    type Transformed : Mapping<Self::Domain, Codomain=F>;

    fn fourier(&self) -> Self::Transformed;
}

impl<F : Float, T, const N : usize> Fourier<F>
for Weighted<T, F>
where T : Fourier<F, Domain = Loc<F, N>> + RealMapping<F, N> {
    type Domain = T::Domain;
    type Transformed = Weighted<T::Transformed, F>;

    #[inline]
    fn fourier(&self) -> Self::Transformed {
        Weighted {
            base_fn : self.base_fn.fourier(),
            weight : self.weight
        }
    }
}
