//! Basic definitions for measures

use serde::Serialize;
use alg_tools::types::Num;
use alg_tools::norms::{Norm, NormExponent};

/// This is used with [`Norm::norm`] to indicate that a Radon norm is to be computed.
#[derive(Copy,Clone,Serialize,Debug)]
pub struct Radon;
impl NormExponent for Radon {}

/// A trait for (Radon) measures.
///
/// Currently has no methods, just the requirement that the Radon norm be implemented.
pub trait Measure<F : Num> : Norm<F, Radon> {
    type Domain;
}

/// Decomposition of measures
pub struct MeasureDecomp;

