/// Definitions related to optimal transport

use crate::types::*;

pub trait TransportLipschitz<Cost> {
    /// Type of floats
    type FloatType : Float;

    /// Returns the transport Lipschitz factor of Self.
    ///
    /// If `Self` is a linear operator $A$ on $ℳ(Ω)$, and `Cost` represents the spatial
    /// cost function $c$, this factor $L$ is such that, for all $0 ≤ λ ∈ ℳ(Ω^2)$,
    /// $$
    ///     \norm{A(π_\#^1-π_\#^0)λ}^2 ≤ L^2 \norm{λ}_{ℳ(Ω^2)} ∫ c(x, y) dλ(x, y).
    /// $$
    fn transport_lipschitz_factor(&self, cost : Cost) -> Self::FloatType;
}
