
use alg_tools::mapping::Apply;
use crate::manifold::ManifoldPoint;
use crate::fb::{Grad, Desc};

/// Structure for distance-to functions
pub struct DistTo<M : ManifoldPoint> {
    base : M
}

impl<M : ManifoldPoint> Apply<M> for DistTo<M> {
    type Output = f64;

    fn apply(&self, x : M) -> Self::Output {
        self.base.dist_to(&x)
    }
}

impl<'a, M : ManifoldPoint> Apply<&'a M> for DistTo<M> {
    type Output = f64;

    fn apply(&self, x : &'a M) -> Self::Output {
        self.base.dist_to(x)
    }
}

/// Structure for distance-to functions
pub struct DistToSquaredDiv2<M : ManifoldPoint> {
    base : M
}

impl<M : ManifoldPoint> Apply<M> for DistToSquaredDiv2<M> {
    type Output = f64;

    fn apply(&self, x : M) -> Self::Output {
        let d = self.base.dist_to(&x);
        d*d / 2.0
    }
}

impl<'a, M : ManifoldPoint> Apply<&'a M> for DistToSquaredDiv2<M> {
    type Output = f64;

    fn apply(&self, x : &'a M) -> Self::Output {
        let d = self.base.dist_to(x);
        d*d / 2.0
    }
}

impl<M : ManifoldPoint> Desc<M> for DistToSquaredDiv2<M> {
    fn desc(&self, τ : f64, x : M) -> M {
        x.exp(&(self.grad(&x) * τ))
    }
}

impl<M : ManifoldPoint> Grad<M> for DistToSquaredDiv2<M> {
    fn grad(&self, x : &M) -> M::Tangent {
       x.log(&self.base)
    }
}
