
use alg_tools::mapping::Apply;
use crate::manifold::ManifoldPoint;
use crate::fb::{Grad, Desc, Prox};
use std::marker::PhantomData;

/// Zero function on manifolds.
pub struct ZeroFn<M : ManifoldPoint> {
    _phantoms : PhantomData<M>
}

impl<M: ManifoldPoint> ZeroFn<M> {
    pub fn new() -> Self {
        ZeroFn{_phantoms : PhantomData }
    }
}

impl<M : ManifoldPoint> Apply<M> for ZeroFn<M> {
    type Output = f64;

    fn apply(&self, _x : M) -> Self::Output {
        0.0
    }
}

impl<'a, M : ManifoldPoint> Apply<&'a M> for ZeroFn<M> {
    type Output = f64;

    fn apply(&self, _x : &'a M) -> Self::Output {
        0.0
    }
}

impl<M : ManifoldPoint> Desc<M> for ZeroFn<M> {
    fn desc(&self, _τ : f64, x : M) -> M {
        x
    }
}

impl<M : ManifoldPoint> Grad<M> for ZeroFn<M> {
    fn grad(&self, x : &M) -> M::Tangent {
       x.tangent_origin()
    }
}

impl<M : ManifoldPoint> Prox<M> for ZeroFn<M> {
    fn prox(&self, _τ : f64, x : M) -> M {
        x
    }
}