/*!
Implementation of the the constant zero function on a manifold.
*/

use alg_tools::mapping::{Mapping, Instance};
use crate::manifold::ManifoldPoint;
use crate::fb::{Grad, Desc, Prox};
use std::marker::PhantomData;

/// Zero function on manifolds.
pub struct ZeroFn<M : ManifoldPoint> {
    _phantoms : PhantomData<M>
}

impl<M: ManifoldPoint> ZeroFn<M> {
    #[allow(dead_code)]
    pub fn new() -> Self {
        ZeroFn{_phantoms : PhantomData }
    }
}

impl<M : ManifoldPoint> Mapping<M> for ZeroFn<M> {
    type Codomain = f64;

    fn apply<I : Instance<M>>(&self, _x : I) -> Self::Codomain {
        0.0
    }
}


impl<M : ManifoldPoint> Desc<M> for ZeroFn<M> {
    fn desc(&self, _τ : f64, x : M) -> M {
        x
    }
}

impl<M : ManifoldPoint> Grad<M> for ZeroFn<M> {
    fn grad(&self, x : &M) -> M::Tangent {
       x.tangent_origin()
    }
}

impl<M : ManifoldPoint> Prox<M> for ZeroFn<M> {
    fn prox(&self, _τ : f64, x : M) -> M {
        x
    }
}