/*!
Newton method in 2D.
*/

use alg_tools::types::*;

#[inline]
pub fn newton_sym1x1<F : Float>(
    g : impl Fn(F) -> (F, F),
    mut x : F,
    iters : usize
) -> F {
    for _i in 0..iters {
        let (a, b) = g(x);
        x -= b / a
    }
    x
}

#[inline]
pub fn newton_sym2x2<F : Float>(
    g : impl Fn(F, F) -> ([F; 3], [F; 2]),
    [mut x1, mut x2] : [F; 2],
    iters : usize
) -> [F; 2] {
    for _i in 0..iters {
        let ([a11, a12, a22], [b1, b2]) = g(x1, x2);
        let q = a11 * a22 - a12 * a12;
        x1 -= (a22 * b1 - a12 * b2) / q;
        x2 -= (a11 * b2 - a12 * b1) / q;
    }
    [x1, x2]
}

