
// We use unicode. We would like to use much more of it than Rust allows.
// Live with it. Embrace it.
#![allow(uncommon_codepoints)]
#![allow(mixed_script_confusables)]
#![allow(confusable_idents)]

use dist::DistToSquaredDiv2;
use fb::forward_backward;
use manifold::EmbeddedManifoldPoint;

mod manifold;
mod fb;
mod cube;
mod dist;
mod zero;

fn main() {
    simple_test()
}

fn simple_test() {
    use cube::*;
    use alg_tools::loc::Loc;
    use Face::*;
    use zero::ZeroFn;
    use alg_tools::mapping::Sum;
    use alg_tools::iterate::{AlgIteratorOptions, Verbose};
    
    let points = [
        OnCube::new(F1, Loc([0.5, 0.5])),
        OnCube::new(F2, Loc([0.5, 0.5])),
        OnCube::new(F4, Loc([0.1, 0.1])),
    ];

    //let x = points[0].clone();
    let x = OnCube::new(F6, Loc([0.5, 0.5]));
    let f = Sum::new(points.into_iter().map(DistToSquaredDiv2));
    let g = ZeroFn::new();
    let τ = 0.1;
    let iter = AlgIteratorOptions{
        max_iter : 100,
        verbose_iter : Verbose::Every(1),
        .. Default::default()
    };

    let x̂ = forward_backward(&f, &g, x, τ, iter);
    println!("result = {}\n{:?}", x̂.embedded_coords(), &x̂);
}
