/*
 * libtu/optparser.h
 *
 * Copyright (c) Tuomo Valkonen 1999-2000.
 * 
 * This file is distributed under the terms of the "Artistic License".
 * See the included file LICENSE for details.
 */

#ifndef __LIBTU_OPTPARSER_H
#define __LIBTU_OPTPARSER_H

#include "types.h"


#define OPT_ID(X)			((X)|0x10000)
#define OPT_ID_RESERVED(X)	((X)|0x20000)

enum{
	OPT__IMM_ARG=0x0100,
	OPT_IMM_ARG=0x0101,			/* may have immediate argument (-fblaah) 	*/
	OPT_CHAINABLE=0x0200,		/* chainable (-xzf)							*/
	OPT_NO_DASH=0x0400,			/* dash not necessary (xzf)					*/
	OPT_MIDLONG=0x0800,			/* have midlong opt (-help)					*/
	OPT_NO_LONG=0x1000,			/* no long opt (--help)						*/
	OPT_ARG=1,					/* option has an argument					*/
	OPT_OPT_ARG=3				/* option may have an argument				*/
};


typedef struct{
	int optid;
	const char *longopt;
	int	flags;
} OptParserOpt;


enum{
	OPT_ID_END=0,
	OPT_ID_ARGUMENT=1,

	E_OPT_INVALID_OPTION=-1,
	E_OPT_INVALID_CHAIN_OPTION=-2,
	E_OPT_SYNTAX_ERROR=-3,
	E_OPT_MISSING_ARGUMENT=-4,
	E_OPT_UNEXPECTED_ARGUMENT=-5
};


extern void optparser_init(int argc, char *const argv[],
						   const OptParserOpt *opts);
extern int  optparser_get_opt();
extern const char* optparser_get_arg();
extern void optparser_print_error();

#endif /* __LIBTU_OPTPARSER_H */
