/*
 * libtu/util.h
 *
 * Copyright (c) Tuomo Valkonen 1999-2000.
 * 
 * This file is distributed under the terms of the "Artistic License".
 * See the included file LICENSE for details.
 */

#ifndef __LIBTU_UTIL_H
#define __LIBTU_UTIL_H

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#include "types.h"


typedef struct{
	const char *name;
	const char *version;
	const char *authors;
	const char *license;
	const char *usage;
} ProgInfo;


extern void libtu_init_argv0(const char *argv0, const ProgInfo *info);
extern void libtu_init(int *argc, char *argv[], const ProgInfo *info);

extern const char *prog_execname();
extern const ProgInfo *prog_info();
extern const char *prog_name();
extern const char *prog_version();
extern const char *prog_authors();
extern const char *prog_license();
extern const char *prog_usage();

#endif /* __LIBTU_UTIL_H */
