
--@module plugin.breadcrumb

local plugin_breadcrumb={}

function plugin_breadcrumb.trail(env, separator, final_separator)
    local f = env.source_file;
    local res = ""
    local next_separator = final_separator
    local path = "../"

    function do_page(f)
        local title = env.pages[f].meta.h1_title or
                      env.pages[f].meta.title or
                      "???"

        if env.pages[f] then
            res = next_separator .. res
            next_separator = separator
            res = string.format("<a href=\"%s\">%s</a>", path, title) .. res
            path = "../" .. path
        end
    end
    
    while true do
        print(f)
        local p, ext = f:match("(.*/)[^/]+/[^/.]+%.([^/]+)")
        if p then
            f = p .. "index." .. ext
            do_page(f)
        else
            break
        end
    end
    
    local ext = f:match("[^/]+/[^/.]+%.([^/]+)")
    if ext then
        do_page("index." .. ext)
    end
    
    return res
end

return plugin_breadcrumb
