
--@module handlers.copy

local path=require("path")

local handlers_copy={}

local dependency=require("dependency")
local log=require("log")

function handlers_copy.phase1(file, env)
end
    
function handlers_copy.phase2(file, env)
    local src=path.join(env.paths.src, file)
    local dst=path.join(env.paths.dst, file)
    if dependency.simple_update_check(dst, {src}) then
        log.log("Copy "..file.."\n")
        local f = io.openX(src, 'r')
        local dstf = io.openX(dst, 'w')
        while true do
            local data=f:read(1024*1024)
            if not data then
                break
            end
            dstf:write(data)
        end
    end
end

return handlers_copy
