
module("handlers.render", package.seeall)

require('markdown')
require('etree')
require('err')
require('environment')
require('config')

--
-- Phase 1: load & markup
--

local phase1_cache={}

function phase1(file, env)
    --local dir = string.match(file, "(.*)/[^/]*")
    --local env = get_environment(dir)
    local f = io.open(file, 'r')
    local data = ''
    local in_meta = false
    local linenum=1
    
    for l in f:lines() do
        if string.match(l, config.meta_marker) then
            in_meta = not in_meta
        elseif in_meta then
            local key, val = string.match(l, "%s*([^:]*)%s*:%s*(.*)%s*")
            if key and val then
                env[key] = val
            else
                err.file_pos(file, linenum, "meta data syntax error")
            end
        else
            data = data.."\n"..l
        end
        linenum = linenum+1
    end
    
    f:close()

    local data2=markdown(data)
    
    phase1_cache[file]=data2
end


--
-- Phase 2: Tag processing
--

-- Vaiko silti toistepäin? Inlinejen tagit pitää
-- prosessoida ennen inlinetystä. Mutta toisaalta
-- templateen myös prosessointi.

local function tag_lgen_inline(env, t)
    a.tag="div"
    -- todo: get inlineable stuff from attrs
    a.attr.class="lgen:inline"
    --table.insert(a, get_inline(env, a)
end

local function tag_lgen_a(env, t)
end


local operations={
    ["lgen:inline"] = tag_lgen_inline,
    ["a"] = tag_lgen_a,
}

local function scan(env, et)
    for _, v in ipairs(et) do
        if type(v)=="table" then
            operations[v.tag](env, v)
        end
    end
end

setmetatable(operations, { __index = function() return scan end })

function phase2(file, env)
    local data=phase1_cache[file]
    --print(data)
    --print("----------")
    local et, msg, line, col, pos = etree.fromstring([[<!DOCTYPE html
    PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><html><body>]]..data..'</body></html>')
    --local et, msg, line, col, pos = lom.parse("<foo>"..data.."</foo>")
    if not et then
        error(string.format("%d:%d(%d): %s", line or -1 , col or -1, pos or -1, msg))
    end
    
    operations[et.tag](env, et)
    
    -- TODO: inlining
    -- maybe
    --phase2_cache[file]=etree.tostring(et);
end



function phase3(file, env)
end
