#!/usr/bin/python3
import argparse
from ssdpy import SSDPServer
import socket

parser=argparse.ArgumentParser(
    description="BorgBackup SSDP/UPnP announcer",
    formatter_class=argparse.RawDescriptionHelpFormatter)

parser.add_argument(
    '--uuid',
    dest='uuid',
    required=True,
    help='UUID of borgbackup instance')

parser.add_argument(
    '--user',
    dest='user',
    required=False,
    help='Borgbackup user (for SSH login)')

def main():
    args=parser.parse_args()

    # Find our own IP
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    s.connect(("8.8.8.8", 80))
    my_ip = s.getsockname()[0]
    s.close()
    location = "ssh://{}{}/".format(args.user + "@" if args.user else "", my_ip)

    server = SSDPServer(usn = args.uuid, device_type = "borg", location = location)
    server.serve_forever()

main()
