// The main documentation is in the README.
#![doc = include_str!("../README.md")]

// We use unicode. We would like to use much more of it than Rust allows.
// Live with it. Embrace it.
#![allow(uncommon_codepoints)]
#![allow(mixed_script_confusables)]
#![allow(confusable_idents)]

#![cfg_attr(feature = "nightly",
    feature(maybe_uninit_array_assume_init,maybe_uninit_slice),
    feature(float_minimum_maximum),
    feature(get_mut_unchecked),
    feature(cow_is_borrowed),
)]

pub mod types;
pub mod instance;
pub mod collection;
pub mod nanleast;
pub mod error;
pub mod parallelism;
pub mod maputil;
pub mod tuple;
pub mod euclidean;
pub mod norms;
#[macro_use]
pub mod loc;
pub mod iter;
pub mod linops;
pub mod iterate;
pub mod tabledump;
pub mod logger;
pub mod linsolve;
pub mod lingrid;
pub mod sets;
pub mod mapping;
pub mod coefficients;
pub mod fe_model;
pub mod bisection_tree;
pub mod nalgebra_support;
pub(crate) mod metaprogramming;
pub mod direct_product;
pub mod convex;
pub mod discrete_gradient;
pub mod operator_arithmetic;

pub use types::*;
