// The main documentation is in the README.
#![doc = include_str!("../README.md")]

// We use unicode. We would like to use much more of it than Rust allows.
// Live with it. Embrace it.
#![allow(uncommon_codepoints)]
#![allow(mixed_script_confusables)]
#![allow(confusable_idents)]

// We need BinaryHeap::retain from nightly
#![feature(binary_heap_retain)]

#![feature(maybe_uninit_uninit_array,maybe_uninit_array_assume_init,maybe_uninit_slice)]
#![feature(try_trait_v2_residual,try_trait_v2)]

#![feature(array_methods)]

#![feature(arc_unwrap_or_clone)]

#![feature(float_minimum_maximum)]

// They don't work:
//#![feature(negative_impls)]
//#![feature(specialization)]

pub mod types;
pub mod nanleast;
pub mod error;
pub mod maputil;
pub mod tuple;
pub mod norms;
#[macro_use]
pub mod loc;
pub mod iter;
pub mod linops;
pub mod iterate;
pub mod tabledump;
pub mod logger;
pub mod linsolve;
pub mod lingrid;
pub mod sets;
pub mod mapping;
pub mod coefficients;
pub mod fe_model;
pub mod bisection_tree;
pub mod nalgebra_support;


pub use types::*;
