/*!
Logging routines for intermediate computational results.
*/

use serde::Serialize;
use crate::tabledump::TableDump;

/// A log of items of type `T` along with log configuration.
/// The constructor takes no arguments;  create the log with `Log{T}()` for `T` your
/// data type, e.g., `Float64`.
#[derive(Debug, Clone)]
pub struct Logger<V> {
    data : Vec<V>,
}

impl<V> Logger<V> {
    /// Create new log
    pub fn new() -> Logger<V> {
        Logger{ data : Vec::new() }
    }

    /// Store the value `v` in the log at index `i`.
    pub fn log(&mut self,  v : V) -> () {
        self.data.push(v);
    }

    /// Get logged data.
    pub fn data(&self) -> &Vec<V> {
        &self.data
    }
}

impl<'a, V : Serialize + 'a> TableDump<'a> for Logger<V> {
    type Iter = std::slice::Iter<'a, V>;

    fn tabledump_entries(&'a self) -> Self::Iter {
        self.data.iter()
    }
}
