use std::marker::PhantomData;

#[derive(Debug)]
pub struct SupportId<S> {
    pub id : usize,
    _phantom : PhantomData<S>
}

// derive fails so need to do Copy and Clone manually

impl<S> Clone for SupportId<S> {
    fn clone(&self) -> Self {
        SupportId { id : self.id, _phantom : PhantomData }
    }
}

impl<S> Copy for SupportId<S> {}

impl<S> From<u32> for SupportId<S> {
    #[inline]
    fn from(id : u32) -> SupportId<S> {
        SupportId { id : id as usize, _phantom : PhantomData }
    }
}

impl<S> From<usize> for SupportId<S> {
    #[inline]
    fn from(id : usize) -> SupportId<S> {
        SupportId { id : id, _phantom : PhantomData }
    }
}

impl<S> Into<usize> for SupportId<S> {
    #[inline]
    fn into(self) -> usize {
        self.id
    }
}

