// Version of lib.rs for stable builds.

// The main documentation is in the README.
#![doc = include_str!("../README.md")]
// We use unicode. We would like to use much more of it than Rust allows.
// Live with it. Embrace it.
#![allow(uncommon_codepoints)]
#![allow(mixed_script_confusables)]
#![allow(confusable_idents)]
// Extra setup for builds with the nightly compiler
#![cfg_attr(
    nightly,
    feature(
        maybe_uninit_array_assume_init,
        maybe_uninit_slice,
        float_minimum_maximum,
        get_mut_unchecked,
        cow_is_borrowed
    )
)]

#[macro_use]
pub(crate) mod metaprogramming;
pub mod collection;
pub mod error;
pub mod euclidean;
pub mod instance;
pub mod maputil;
pub mod nanleast;
pub mod norms;
pub mod parallelism;
pub mod tuple;
pub mod types;
#[macro_use]
pub mod loc;
pub mod bisection_tree;
pub mod coefficients;
pub mod convex;
pub mod direct_product;
pub mod discrete_gradient;
pub mod fe_model;
pub mod iter;
pub mod iterate;
pub mod lingrid;
pub mod linops;
pub mod linsolve;
pub mod logger;
pub mod mapping;
pub mod nalgebra_support;
pub mod operator_arithmetic;
pub mod sets;
pub mod tabledump;

pub use types::*;
