/*!
Arithmetic functions that are valid in a ‘const context”, i.e., can be computed at compile-time.
*/

/// Calculate $n!$. Valid in a const-context.
///
/// (The version in the crate `num_integer` deesn't currently work in a const-context.)
pub const fn factorial(n : usize) -> usize {
    const fn f(i : usize, a : usize) -> usize {
        if i==0 { a } else { f(i-1, i*a) }
    }
    f(n, 1)
}

/// Calculate $n \choose k$. Valid in a const-context.
///
/// (The version in the crate `num_integer` doesn't currently work in a const-context.)
pub const fn binomial(n : usize, k : usize) -> usize {
    factorial(n)/(factorial(n-k)*factorial(k))
}

/// Calculate $n^k$. Valid in a const-context.
///
/// (The version in the crate `num_integer` doesn't currently work in a const-context.)
pub const fn pow(n : usize, k : usize) -> usize {
    const fn pow_accum(n : usize, k : usize, accum : usize) -> usize {
        if k==0 { accum } else { pow_accum(n, k-1, accum*n) }
    }
    pow_accum(n, k, 1)
}
