/*!
Metaprogramming tools
*/

/// Reference `x` if so indicated by the first parameter.
/// Typically to be used from another macro. See the implementation of
/// [power][crate::vectorspace::powerspace] and [product spaces][crate::vectorspace::productspace].
///
/// ```ignore
/// maybe_ref!(ref, V)   // ➡ &V
/// maybe_ref!(noref, V) // ➡ V
/// ```
#[macro_export]
macro_rules! maybe_ref {
    (ref, $x:expr) => { &$x };
    (noref, $x:expr) => { $x };
    (ref, $x:ty) => { &$x };
    (noref, $x:ty) => { $x };
}

/// Choose `a` if first argument is the literal `ref`, otherwise `b`.
#[macro_export]
macro_rules! ifref {
    (noref, $a:expr, $b:expr) => { $b };
    (ref, $a:expr, $b:expr) => { $a };
}


/// Annotate `x` with a lifetime if the first parameter
/// Typically to be used from another macro. See the implementation of
/// [power][crate::vectorspace::powerspace] and [product spaces][crate::vectorspace::productspace].
///
/// ```ignore
/// maybe_ref!(ref, &'a V)    // ➡ &'a V
/// maybe_ref!(noref, &'a V)  // ➡ V
/// ```
#[macro_export]
macro_rules! maybe_lifetime {
    (ref, $x:ty) => { $x };
    (noref, &$lt:lifetime $x:ty) => { $x };
    (noref, &$x:ty) => { $x };
}

