///! Base types for simple (finite) element models.

/// A local model can be evaluated for value and differential
pub trait LocalModel<Domain, Codomain> {
    /// Get the value of the model at `x`
    fn value(&self, x : &Domain) -> Codomain;
    /// Get the differential of the model at `x`
    fn differential(&self, x : &Domain) -> Domain;
}

/// A real local model is a minimisable [`LocalModel`].
pub trait RealLocalModel<S, Domain, Codomain> : LocalModel<Domain, Codomain> {
    /// Find a (minimum, minimiser) pair for he model within `el`, which is
    /// typically a simplex subset of `Domain`.
    fn minimise(&self, el : &S) -> (Domain, Codomain);
}
