/*!
Error passing helper types
*/

use std::error::Error;

/// A [`Result`] containing `T` or a dynamic error type
pub type DynResult<T> = Result<T, Box<dyn Error>>;

/// A [`Result`] containing `()` or a dynamic error type
pub type DynError = DynResult<()>;

#[derive(Clone, Debug)]
/// Type for numerical errors.
pub struct NumericalError(
    /// Provides additional information about the error
    pub &'static str
);

impl std::fmt::Display for NumericalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self.0 {
            "" => write!(f, "Numerical error"),
            s => write!(f, "{s}"),
        }
    }
}

impl std::error::Error for NumericalError {}
