__precompile__()

module PlotResults


########################
# Load external modules
########################

using DelimitedFiles, CSV, DataFrames
using PlotlyJS
using Colors
using XLSX: writetable
using Statistics

export fv_plot, ssim_plot, psnr_plot, calculate_statistics

global mystart = 38
global myend = 135

function fv_plot(name :: String, save_plot::Bool=true)
    save_path = "./img/$(name)200x300_pdps_known_fv_plot.html"
    #################################################
    orig = Vector{GenericTrace{Dict{Symbol, Any}}}()
    #################################################
    directory_path = "./img/"
    files = readdir(directory_path)
    filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_proximal") && endswith(file, "0.txt"), files)

    # Define an array of line styles and colors
    # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
    line_colors = distinguishable_colors(15)

    for (index,file) in enumerate(filtered_files)
        filename = directory_path*file
        #data = readdlm(filename, '\t', skipstart=1)
        data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame

        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :function_value])

        #line_style = line_styles[i]
        line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)

        trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                line_color=line_color, line_dash="dot", name="proxi (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
        push!(orig, trace)
    end

    #####################################################
    identity = Vector{GenericTrace{Dict{Symbol, Any}}}()
    #####################################################
    directory_path = "./img/"
    files = readdir(directory_path)
    filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_primalonly") && endswith(file, "0.txt"), files)

    # Define an array of line styles and colors
    # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
    line_colors = distinguishable_colors(15)

    for (index,file) in enumerate(filtered_files)
        filename = directory_path*file
        #data = readdlm(filename, '\t', skipstart=1)
        data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame

        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :function_value])

        #line_style = line_styles[i]
        line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)

        trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                line_color=line_color, line_dash="dashdot", name="primo (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
        push!(identity, trace)
    end


     #####################################################
     adhoc = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_greedy") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = distinguishable_colors(15)
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
         # Extract the columns you want to plot
         X = Int64.(data[mystart:myend,:iter])
         Y = Float64.(data[mystart:myend, :function_value])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                 line_color=line_color, line_dash="dash", name="greed (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
         push!(identity, trace)
     end


     #####################################################
     rotation = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_rotation") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = distinguishable_colors(15)
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
         # Extract the columns you want to plot
         X = Int64.(data[mystart:myend,:iter])
         Y = Float64.(data[mystart:myend, :function_value])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                 line_color=line_color, line_dash="longdashdot", name="rotat (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
         push!(identity, trace)
     end     


     #####################################################
     affine = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_dualscaling") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = distinguishable_colors(15)
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
         # Extract the columns you want to plot
         X = Int64.(data[mystart:myend,:iter])
         Y = Float64.(data[mystart:myend, :function_value])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                 line_color=line_color, line_dash="solid", name="dusca (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
         push!(identity, trace)
     end      

     #####################################################
     zerodual = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_zerodual") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = distinguishable_colors(15)
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
         # Extract the columns you want to plot
         X = Int64.(data[mystart:myend,:iter])
         Y = Float64.(data[mystart:myend, :function_value])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                 line_color=line_color, line_dash="longdash", name="zerod (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
         push!(identity, trace)
     end

    layout = Layout(yaxis_type="log",legend_title_text="Function values")  # Set legend title
    
    if save_plot && !isempty(save_path)
        plotlyjs = plot([orig;identity;adhoc;rotation;affine;zerodual], layout)
        open(save_path, "w") do io
            PlotlyBase.to_html(io, plotlyjs.plot)
        end
    elseif save_plot
        println("Please provide a valid save path.")
    end

    return  plot([orig;identity;adhoc;rotation;affine;zerodual],layout)
end


#########################################################
# FUNCTION FOR SSIM
#########################################################
function ssim_plot(name :: String, save_plot::Bool=true)
    save_path = "./img/$(name)200x300_pdps_known_ssim_plot.html"
    #################################################
    orig = Vector{GenericTrace{Dict{Symbol, Any}}}()
    #################################################
    directory_path = "./img/"
    files = readdir(directory_path)
    filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_proximal") && endswith(file, "0.txt"), files)

    # Define an array of line styles and colors
    # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
    line_colors = distinguishable_colors(15)

    for (index,file) in enumerate(filtered_files)
        filename = directory_path*file
        #data = readdlm(filename, '\t', skipstart=1)
        data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame

        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :ssim])

        #line_style = line_styles[i]
        line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)

        trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                line_color=line_color, line_dash="dot", name="proxi (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
        push!(orig, trace)
    end

    #####################################################
    identity = Vector{GenericTrace{Dict{Symbol, Any}}}()
    #####################################################
    directory_path = "./img/"
    files = readdir(directory_path)
    filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_primalonly") && endswith(file, "0.txt"), files)

    # Define an array of line styles and colors
    # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
    line_colors = distinguishable_colors(15)

    for (index,file) in enumerate(filtered_files)
        filename = directory_path*file
        #data = readdlm(filename, '\t', skipstart=1)
        data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame

        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :ssim])

        #line_style = line_styles[i]
        line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)

        trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                line_color=line_color, line_dash="dashdot", name="primo (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
        push!(identity, trace)
    end


     #####################################################
     adhoc = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_greedy") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = distinguishable_colors(15)
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :ssim])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                 line_color=line_color, line_dash="dash", name="greed (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
         push!(identity, trace)
     end


     #####################################################
     rotation = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_rotation") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = distinguishable_colors(15)
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :ssim])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                 line_color=line_color, line_dash="longdashdot", name="rotat (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
         push!(identity, trace)
     end     


     #####################################################
     affine = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_dualscaling") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = distinguishable_colors(15)
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :ssim])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                 line_color=line_color, line_dash="solid", name="dusca (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
         push!(identity, trace)
     end 

    #####################################################
    zerodual = Vector{GenericTrace{Dict{Symbol, Any}}}()
    #####################################################
    directory_path = "./img/"
    files = readdir(directory_path)
    filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_zerodual") && endswith(file, "0.txt"), files)

    # Define an array of line styles and colors
    # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
    line_colors = distinguishable_colors(15)

    for (index,file) in enumerate(filtered_files)
        filename = directory_path*file
        #data = readdlm(filename, '\t', skipstart=1)
        data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame

    # Extract the columns you want to plot
    X = Int64.(data[mystart:myend,:iter])
    Y = Float64.(data[mystart:myend, :ssim])

        #line_style = line_styles[i]
        line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)

        trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                line_color=line_color, line_dash="longdash", name="zerod (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
        push!(identity, trace)
    end  

    layout = Layout(yaxis_type="log", legend_title_text="SSIM")  # Set legend title
    
    if save_plot && !isempty(save_path)
        plotlyjs = plot([orig;identity;adhoc;rotation;affine;zerodual], layout)
        open(save_path, "w") do io
            PlotlyBase.to_html(io, plotlyjs.plot)
        end
    elseif save_plot
        println("Please provide a valid save path.")
    end

    return  plot([orig;identity;adhoc;rotation;affine;zerodual],layout)
end



#########################################################
# FUNCTION FOR PSNR
#########################################################
function psnr_plot(name :: String, save_plot::Bool=true)
    save_path = "./img/$(name)200x300_pdps_known_psnr_plot.html"
    #################################################
    orig = Vector{GenericTrace{Dict{Symbol, Any}}}()
    #################################################
    directory_path = "./img/"
    files = readdir(directory_path)
    filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_proximal") && endswith(file, "0.txt"), files)

    # Define an array of line styles and colors
    # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
    line_colors = distinguishable_colors(15)

    for (index,file) in enumerate(filtered_files)
        filename = directory_path*file
        #data = readdlm(filename, '\t', skipstart=1)
        data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame

        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :psnr])

        #line_style = line_styles[i]
        line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)

        trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                line_color=line_color, line_dash="dot", name="proxi (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
        push!(orig, trace)
    end

    #####################################################
    identity = Vector{GenericTrace{Dict{Symbol, Any}}}()
    #####################################################
    directory_path = "./img/"
    files = readdir(directory_path)
    filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_primalonly") && endswith(file, "0.txt"), files)

    # Define an array of line styles and colors
    # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
    line_colors = distinguishable_colors(15)

    for (index,file) in enumerate(filtered_files)
        filename = directory_path*file
        #data = readdlm(filename, '\t', skipstart=1)
        data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame

        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :psnr])

        #line_style = line_styles[i]
        line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)

        trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                line_color=line_color, line_dash="dashdot", name="primo (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
        push!(identity, trace)
    end


     #####################################################
     adhoc = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_greedy") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = distinguishable_colors(15)
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :psnr])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                 line_color=line_color, line_dash="dash", name="greed (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
         push!(identity, trace)
     end


     #####################################################
     rotation = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_rotation") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = distinguishable_colors(15)
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :psnr])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                 line_color=line_color, line_dash="longdashdot", name="rotat (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
         push!(identity, trace)
     end     

     #####################################################
     affine = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_dualscaling") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = distinguishable_colors(15)
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :psnr])

         #line_style = line_styles[i]
         line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                 line_color=line_color, line_dash="solid", name="dusca (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
         push!(identity, trace)
     end  

     #####################################################
     zerodual = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)200x300_pdps_known_zerodual") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = distinguishable_colors(15)
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :psnr])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
        # Extract parameters for legend
        α, τ₀, σ₀ = extract_parameters(filename)
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.3f}",
                                 line_color=line_color, line_dash="longdash", name="zerod (α=$α, τ₀=$τ₀, σ₀=$σ₀)")
         push!(identity, trace)
     end  


    layout = Layout(yaxis_type="log", legend_title_text="PSNR")  # Set legend title
    
    if save_plot && !isempty(save_path)
        plotlyjs = plot([orig;identity;adhoc;rotation;affine; zerodual], layout)
        open(save_path, "w") do io
            PlotlyBase.to_html(io, plotlyjs.plot)
        end
    elseif save_plot
        println("Please provide a valid save path.")
    end

    return  plot([orig;identity;adhoc;rotation;affine;zerodual],layout)
end

######################
# Parameter extraction
######################
function extract_parameters(filename :: String)
        # Extracting parameters
        params_line = readlines(filename)[1]

        # Split the line by commas and trim each part
        params_parts = map(strip, split(params_line, ','))

        # Initialize variables to store parameter values
        α_value, τ₀_value, σ₀_value = missing, missing, missing

        # Look for specific substrings to identify the values of α, τ₀, and σ₀
        for param_part in params_parts
            if contains(param_part, "α = ")
                α_value = parse(Float64, split(param_part, '=')[2])
            elseif contains(param_part, "τ₀ = ")
                τ₀_value = parse(Float64, split(param_part, '=')[2])
            elseif contains(param_part, "σ₀ = ")
                σ₀_value = parse(Float64, split(param_part, '=')[2])
            end
        end

        # Assign the values to α, τ₀, and σ₀
        α = α_value
        τ₀ = τ₀_value
        σ₀ = σ₀_value
        return α, τ₀, σ₀
end


function calculate_statistics()
    ImName = ("lighthouse200x300", "shepplogan256x256", "brainphantom256x256")
    AlgName = ("dualscaling", "greedy","noprediction","primalonly","proximal","rotation","zerodual")
    mystart = 41 # Corresponds to the 500th iterate
    
    # Define an array to store results
    results = DataFrame(experiment = String[], α = Float64[], algorithm = String[], psnr_mean1 = Float64[], psnr_mean500 = Float64[], psnr_ci = String[], ssim_mean1 = Float64[], ssim_mean500 = Float64[], ssim_ci = String[])

    for imname in ImName
        for algname in AlgName
            directory_path = "./img/"
            files = readdir(directory_path)
            filtered_files = filter(file -> startswith(file, "$(imname)_pdps_known_$(algname)") && endswith(file, ".txt"), files)

            for file in filtered_files
                filename = directory_path * file
                data = CSV.File(filename, delim='\t', header=2) |> DataFrame

                # Extract α from filename
                α, _, _ = extract_parameters(filename)


                # Extract SSIM and PSNR columns starting from 1st iteration
                ssim_values1 = Float64.(data[:, :ssim])
                psnr_values1 = Float64.(data[:, :psnr])

                # Extract SSIM and PSNR columns starting from 500th iteration
                ssim_values500 = Float64.(data[mystart:end, :ssim])
                psnr_values500 = Float64.(data[mystart:end, :psnr])

                # Calculate mean and confidence intervals
                ssim_mean1 = round(mean(ssim_values1), digits=4)
                psnr_mean1 = round(mean(psnr_values1), digits=4)

                ssim_mean500 = round(mean(ssim_values500), digits=4)
                psnr_mean500 = round(mean(psnr_values500), digits=4)
                ssim_std500 = round(std(ssim_values500), digits=4)
                psnr_std500 = round(std(psnr_values500), digits=4)
                n = length(ssim_values500)

                ssim_ci_lower = round(ssim_mean500 - 1.96 * ssim_std500 / sqrt(n), digits=4)
                ssim_ci_upper = round(ssim_mean500 + 1.96 * ssim_std500 / sqrt(n), digits=4)
                psnr_ci_lower = round(psnr_mean500 - 1.96 * psnr_std500 / sqrt(n), digits=4)
                psnr_ci_upper = round(psnr_mean500 + 1.96 * psnr_std500 / sqrt(n), digits=4)

                ssim_ci = "$(ssim_ci_lower) - $(ssim_ci_upper)"
                psnr_ci = "$(psnr_ci_lower) - $(psnr_ci_upper)"
                experiment = "$(imname)"
                algorithm = "$(algname)"

                # Append results to DataFrame
                push!(results, (experiment, α, algorithm, psnr_mean1, psnr_mean500, psnr_ci, ssim_mean1, ssim_mean500, ssim_ci))
            end
        end
    end
    sort!(results, [:experiment, :α])
    excel_path = "./img/summarystats.xlsx"
        if isfile(excel_path)
            rm(excel_path)
        end
            writetable(excel_path, sheetname="Experiments", results)
end
end # Module