__precompile__()

module PlotResults


########################
# Load external modules
########################

using DelimitedFiles, CSV, DataFrames
using PlotlyJS

export fv_plot, ssim_plot, psnr_plot

global mystart = 38
global myend = 75

function fv_plot(name :: String, save_plot::Bool=true)
    save_path = "./img/$(name)256x256_pdps_known_fv_plot.html"
    #################################################
    orig = Vector{GenericTrace{Dict{Symbol, Any}}}()
    #################################################
    directory_path = "./img/"
    files = readdir(directory_path)
    filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_proximal") && endswith(file, "0.txt"), files)

    # Define an array of line styles and colors
    # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
    line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]

    for (index,file) in enumerate(filtered_files)
        filename = directory_path*file
        #data = readdlm(filename, '\t', skipstart=1)
        data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame

        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :function_value])

        #line_style = line_styles[i]
        line_color = line_colors[index]

        trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                line_color=line_color, line_dash="dot", name="proxi")
        push!(orig, trace)
    end

    #####################################################
    identity = Vector{GenericTrace{Dict{Symbol, Any}}}()
    #####################################################
    directory_path = "./img/"
    files = readdir(directory_path)
    filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_primalonly") && endswith(file, "0.txt"), files)

    # Define an array of line styles and colors
    # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
    line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]

    for (index,file) in enumerate(filtered_files)
        filename = directory_path*file
        #data = readdlm(filename, '\t', skipstart=1)
        data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame

        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :function_value])

        #line_style = line_styles[i]
        line_color = line_colors[index]

        trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                line_color=line_color, line_dash="dashdot", name="primo")
        push!(identity, trace)
    end


     #####################################################
     adhoc = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_greedy") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
         # Extract the columns you want to plot
         X = Int64.(data[mystart:myend,:iter])
         Y = Float64.(data[mystart:myend, :function_value])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                 line_color=line_color, line_dash="dash", name="greed τ")
         push!(identity, trace)
     end


     #####################################################
     rotation = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_rotation") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
         # Extract the columns you want to plot
         X = Int64.(data[mystart:myend,:iter])
         Y = Float64.(data[mystart:myend, :function_value])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                 line_color=line_color, line_dash="longdashdot", name="rotat")
         push!(identity, trace)
     end     


     #####################################################
     affine = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_dualscaling") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
         # Extract the columns you want to plot
         X = Int64.(data[mystart:myend,:iter])
         Y = Float64.(data[mystart:myend, :function_value])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                 line_color=line_color, line_dash="solid", name="dusca")
         push!(identity, trace)
     end      

    #####################################################
    zerodual = Vector{GenericTrace{Dict{Symbol, Any}}}()
    #####################################################
    directory_path = "./img/"
    files = readdir(directory_path)
    filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_zerodual") && endswith(file, "0.txt"), files)

    # Define an array of line styles and colors
    # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
    line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]

    for (index,file) in enumerate(filtered_files)
        filename = directory_path*file
        #data = readdlm(filename, '\t', skipstart=1)
        data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame

        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :function_value])

        #line_style = line_styles[i]
        line_color = line_colors[index]

        trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                line_color=line_color, line_dash="longdash", name="zerod")
        push!(identity, trace)
    end      

    layout = Layout(legend_title_text="Function values")  # Set legend title
    
    if save_plot && !isempty(save_path)
        plotlyjs = plot([orig;identity;adhoc;rotation;affine;zerodual],layout)
        open(save_path, "w") do io
            PlotlyBase.to_html(io, plotlyjs.plot)
        end
    elseif save_plot
        println("Please provide a valid save path.")
    end

    return  plot([orig;identity;adhoc;rotation;affine;zerodual],layout)
end


#########################################################
# FUNCTION FOR SSIM
#########################################################
function ssim_plot(name :: String, save_plot::Bool=true)
    save_path = "./img/$(name)256x256_pdps_known_ssim_plot.html"
    #################################################
    orig = Vector{GenericTrace{Dict{Symbol, Any}}}()
    #################################################
    directory_path = "./img/"
    files = readdir(directory_path)
    filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_proximal") && endswith(file, "0.txt"), files)

    # Define an array of line styles and colors
    # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
    line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]

    for (index,file) in enumerate(filtered_files)
        filename = directory_path*file
        #data = readdlm(filename, '\t', skipstart=1)
        data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame

        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :ssim])

        #line_style = line_styles[i]
        line_color = line_colors[index]

        trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                line_color=line_color, line_dash="dot", name="proxi")
        push!(orig, trace)
    end

    #####################################################
    identity = Vector{GenericTrace{Dict{Symbol, Any}}}()
    #####################################################
    directory_path = "./img/"
    files = readdir(directory_path)
    filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_primalonly") && endswith(file, "0.txt"), files)

    # Define an array of line styles and colors
    # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
    line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]

    for (index,file) in enumerate(filtered_files)
        filename = directory_path*file
        #data = readdlm(filename, '\t', skipstart=1)
        data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame

        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :ssim])

        #line_style = line_styles[i]
        line_color = line_colors[index]

        trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                line_color=line_color, line_dash="dashdot", name="primo")
        push!(identity, trace)
    end


     #####################################################
     adhoc = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_greedy") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :ssim])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                 line_color=line_color, line_dash="dash", name="greed")
         push!(identity, trace)
     end


     #####################################################
     rotation = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_rotation") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :ssim])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                 line_color=line_color, line_dash="longdashdot", name="rotat")
         push!(identity, trace)
     end     


     #####################################################
     affine = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_dualscaling") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :ssim])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                 line_color=line_color, line_dash="solid", name="dusca")
         push!(identity, trace)
     end 

    #####################################################
    zerodual = Vector{GenericTrace{Dict{Symbol, Any}}}()
    #####################################################
    directory_path = "./img/"
    files = readdir(directory_path)
    filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_zerodual") && endswith(file, "0.txt"), files)

    # Define an array of line styles and colors
    # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
    line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]

    for (index,file) in enumerate(filtered_files)
        filename = directory_path*file
        #data = readdlm(filename, '\t', skipstart=1)
        data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame

    # Extract the columns you want to plot
    X = Int64.(data[mystart:myend,:iter])
    Y = Float64.(data[mystart:myend, :ssim])

        #line_style = line_styles[i]
        line_color = line_colors[index]

        trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                line_color=line_color, line_dash="longdash", name="zerod")
        push!(identity, trace)
    end  

    layout = Layout(yaxis_type="log", legend_title_text="SSIM")  # Set legend title
    
    if save_plot && !isempty(save_path)
        plotlyjs = plot([orig;identity;adhoc;rotation;affine;zerodual], layout)
        open(save_path, "w") do io
            PlotlyBase.to_html(io, plotlyjs.plot)
        end
    elseif save_plot
        println("Please provide a valid save path.")
    end

    return  plot([orig;identity;adhoc;rotation;affine;zerodual],layout)
end



#########################################################
# FUNCTION FOR PSNR
#########################################################
function psnr_plot(name :: String, save_plot::Bool=true)
    save_path = "./img/$(name)256x256_pdps_known_psnr_plot.html"
    #################################################
    orig = Vector{GenericTrace{Dict{Symbol, Any}}}()
    #################################################
    directory_path = "./img/"
    files = readdir(directory_path)
    filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_proximal") && endswith(file, "0.txt"), files)

    # Define an array of line styles and colors
    # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
    line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]

    for (index,file) in enumerate(filtered_files)
        filename = directory_path*file
        #data = readdlm(filename, '\t', skipstart=1)
        data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame

        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :psnr])

        #line_style = line_styles[i]
        line_color = line_colors[index]

        trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                line_color=line_color, line_dash="dot", name="proxi")
        push!(orig, trace)
    end

    #####################################################
    identity = Vector{GenericTrace{Dict{Symbol, Any}}}()
    #####################################################
    directory_path = "./img/"
    files = readdir(directory_path)
    filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_primalonly") && endswith(file, "0.txt"), files)

    # Define an array of line styles and colors
    # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
    line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]

    for (index,file) in enumerate(filtered_files)
        filename = directory_path*file
        #data = readdlm(filename, '\t', skipstart=1)
        data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame

        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :psnr])

        #line_style = line_styles[i]
        line_color = line_colors[index]

        trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                line_color=line_color, line_dash="dashdot", name="primo")
        push!(identity, trace)
    end


     #####################################################
     adhoc = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_greedy") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :psnr])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                 line_color=line_color, line_dash="dash", name="greed")
         push!(identity, trace)
     end


     #####################################################
     rotation = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_rotation") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :psnr])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                 line_color=line_color, line_dash="longdashdot", name="rotat")
         push!(identity, trace)
     end     

     #####################################################
     affine = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_dualscaling") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :psnr])

         #line_style = line_styles[i]
         line_color = line_colors[index]
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                 line_color=line_color, line_dash="solid", name="dusca")
         push!(identity, trace)
     end  

     #####################################################
     zerodual = Vector{GenericTrace{Dict{Symbol, Any}}}()
     #####################################################
     directory_path = "./img/"
     files = readdir(directory_path)
     filtered_files = filter(file -> startswith(file, "$(name)256x256_pdps_known_zerodual") && endswith(file, "0.txt"), files)
 
     # Define an array of line styles and colors
     # line_styles = ["solid", "dash", "dot", "dashdot", "longdash"]
     line_colors = ["blue", "red", "green", "orange", "purple", "cyan", "magenta", "yellow", "grey"]
 
     for (index,file) in enumerate(filtered_files)
         filename = directory_path*file
         #data = readdlm(filename, '\t', skipstart=1)
         data = CSV.File(filename, delim='\t'; header = 2) |> DataFrame
 
        # Extract the columns you want to plot
        X = Int64.(data[mystart:myend,:iter])
        Y = Float64.(data[mystart:myend, :psnr])
 
         #line_style = line_styles[i]
         line_color = line_colors[index]
 
         trace = PlotlyJS.scatter(;x=X, y=Y, mode="lines", hovertemplate="%{x:.0f},%{y:.1f}",
                                 line_color=line_color, line_dash="longdash", name="zerod")
         push!(identity, trace)
     end  


    layout = Layout(yaxis_type="log", legend_title_text="PSNR")  # Set legend title
    
    if save_plot && !isempty(save_path)
        plotlyjs = plot([orig;identity;adhoc;rotation;affine; zerodual], layout)
        open(save_path, "w") do io
            PlotlyBase.to_html(io, plotlyjs.plot)
        end
    elseif save_plot
        println("Please provide a valid save path.")
    end

    return  plot([orig;identity;adhoc;rotation;affine;zerodual],layout)
end


end # Module