
# ImageTools

Author: Tuomo Valkonen <tuomov@iki.fi>

This repository contains some tools for doing mathematical imaging in Julia:

  * Effective visualisation based directly on `GR` instead of `Plots`. A sample visualisation main loop that calls
    [AlgTools][]-style step routines.
  * Sub-pixelresolution image translation and sub-image extraction
  * Calculation of discrete image gradients (2D, 3D 3D vector fields)
  * A very simple image filtering code that seems more efficient than the `ImageFiltering`
  package.
  
The code is used, for example, by <http://dx.doi.org/10.5281/zenodo.3659180>.

## Installation

To install this package, first clone the repository and [AlgTools][] with [Mercurial](https://www.mercurial-scm.org/):

```console
$ hg clone https://tuomov.iki.fi/repos/AlgTools/
$ hg clone https://tuomov.iki.fi/repos/ImageTools/
```

(Canonical public repository URLs indicated here.)
AlgTools has to be installed under the some location as ImageTools.
Then add the repository to Julia with `Pkg.develop`:

```console
julia>] develop LOCATION_OF/ImageTools/
```

Here replace `LOCATION_OF/ImageTools` with path where you cloned ImageTools. (If you did not change directory after cloning, simply use `ImageTools`.)
Afterwards, you may use the package with:

```console
julia> using ImageTools
```

This package is not and is not planned to be available via `Pkg.add` as it is based on the worst and must unusable version control system ever invented: Git.

## Testing

To run a simple denoising test using FISTA, use

```console
$ julia --project=DenoiseTest
julia> using DenoiseTest
julia> test_denoise()
```

  [AlgTools]: https://tuomov.iki.fi/software/AlgTools/
