
#############################################
# Utilities to work with colourmapped images
#############################################

module ColourTools

using ColorTypes: Gray

# Our exports

export grayimg,
       mapped_img,
       clip

# Clip image values to allowed range
clip = x -> min(max(x, 0.0), 1.0)

# Tell that raw image data is grayscale
grayimg = im -> Gray.(clip.(im))

# Apply a colourmap (vector of RGB objects) to raw image data
function mapped_img(im, cmap)
    l = length(cmap)
    apply = t -> cmap[1+round(UInt8, clip(t) * (l-1))]
    return apply.(im)
end

end

