
__precompile__()

"""

`module AlgTools`

This module implements useful code for implementing iterative algorithms.
For further documentation, see the submodules
`FunctionalProgramming`, `StructTools`, `LinkedLists`, `Logger`, `Iterate`,
`VectorMath`, `Util`, `ThreadUtil`, `Comms`, `LinOps`, `DifferentiableFN`,
`Metaprogramming`, `Loops`, `ZipArrays`, `LinSolve`, and `PlanarFE`.
"""
module AlgTools

include("FunctionalProgramming.jl")
include("StructTools.jl")
include("LinkedLists.jl")
include("Logger.jl")
include("Iterate.jl")
include("VectorMath.jl")
include("Util.jl")
include("ThreadUtil.jl")
include("Comms.jl")
include("LinOps.jl")
include("DifferentiableFN.jl")
include("Metaprogramming.jl")
include("Loops.jl")
include("ZipArrays.jl")
include("LinSolve.jl")
include("PlanarFE.jl")

end
