###################################
# Tools for functional programming
###################################

"""

`module AlgTools.FunctionalProgramming`

This module implements:
- `curry`
- `curryflip`
"""
module FunctionalProgramming

##############
# Our exports
##############

export curry,
       curryflip,
       maybe

###########
# Currying
###########

"""
`curry(f)` and `curry(f, x)`

From a function `f` of parameters `(x, y...; kwargs...)` construct a function `g`
of parameter `x`, returning a function of parameter `(y...; kwargs...)`.

The version with parameter `x` already applies the first argument, returning a function
of `(y...; kwargs...)`.
"""
function curry(f::Function)
    return x -> (y...; kwargs...)-> f(x, y...; kwargs...)
end

function curry(f::Function, x)
    return (y...; kwargs...)-> f(x, y...; kwargs...)
end

"""
`curryflip(f)` and `curryflip(f, y...; kwargs...)

From a function `f` of parameters `(x, y...; kwargs...)` construct a function `g`
of parameter `(y...; kargs...)`, returning a function of parameter `x`

The version with parametesr `(y...; kwargs...)` already applies these parameters,
returning a function of `x`.
"""
function curryflip(f::Function)
    return (y...; kwargs...) -> x -> f(x, y...; kwargs...)
end

function curryflip(f::Function, y...; kwargs...)
    return x ->f(x, y...; kwargs...)
end

"""
`maybe(f, x)`

Returns `nothing` if `x` is `nothing, otherwise `f(x)`.
"""
maybe( :: Function, :: Nothing) = nothing
maybe(f :: Function, x :: T) where T = f(x)

end # module
