module DifferentiableFN

using ..LinOps

export Func,
       DiffF,
       value,
       differential,
       adjoint_differential

abstract type Func{X,Y} end
abstract type DiffF{X,Y,T} <: Func{X, Y} end

function value(f :: F, x :: X) :: Y where {X, Y, F <: Func{X,Y}}
    @error "`value` unimplemented"
end

# function (f :: D)(x::X) where {X, Y, T <: LinOp{X, Y}, D <: DiffF{X, Y, T}}
#     return value(x)
# end

function differential(f :: DiffF{X,Y,T}, x :: X) :: T where {X, Y, T <: LinOp{X, Y}}
    @error "`differential` unimplemented"
end

function adjoint_differential(f :: DiffF{X,Y,T}, x :: X) :: T where {X, Y, T <: LinOp{X, Y}}
    @error "`adjoint_differential` unimplemented"
end

function adjoint_differential(f :: DiffF{X,Y, T}, x :: X) :: T where {X, Y, T <: AdjointableOp{X, Y}}
    return AdjointOp(differential(f, x))
end

end
