###########################
# Some threading utilities
###########################

__precompile__()

module ThreadUtil

##############
# Our exports
##############

export @threadsif,
       @background,
       @backgroundif


##########
# Threads
##########

macro threadsif(threads, loop)
    return esc(:(if $threads
                    Threads.@threads $loop
                else
                    $loop
                end))
end

macro background(bgtask, fgtask)
    return :(t = Threads.@spawn $(esc(bgtask));
             $(esc(fgtask));
             wait(t))
end

macro backgroundif(threads, bgtask, fgtask)
    return :(if $(esc(threads))
                @background $(esc(bgtask)) $(esc(fgtask))
            else
                $(esc(bgtask))
                $(esc(fgtask))
            end)
end

end # Module

