#########################################
# Helpers for communication via channels
#########################################

module Comms

__precompile__()

##############
# Our exports
##############

export process_channel,
       put_onlylatest!

####################
# Channel iteration
####################

function process_channel(fn, rc)
    while true
        d=take!(rc)
        # Take only the latest image to visualise
        while isready(rc)
            d=take!(rc)
        end
        # We're done if we were fed nothing
        if isnothing(d)
            break
        end
        try
            fn(d)
        catch ex
            error("Exception in process_channel handler. Terminating.\n$(ex)")
            throw(ex)
        end 
    end
end

#############################################
# Ensure only latest data is in a Channel(1)
#############################################

function put_onlylatest!(rc, d)
    while isready(rc)
        take!(rc)
    end
    put!(rc, d)
end

end # Module
